import React from "react";
import { BrowserRouter as Router, Routes, Route } from "react-router-dom";
import { ThemeProvider, CssBaseline } from "@mui/material";
import theme from "./theme";
import ToastProvider from "./ToastProvider";
import AdminDashboard from "./pages/modulo-admin/AdminDashBoard";
import VentasDashboard from "./pages/modulo-ventas/VentasDashboard";
import LoginPage from "./components/LoginPage";
import { DollarProvider } from "./DollarPrice";
function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <ToastProvider>
        <DollarProvider>
          <Router>
            <Routes>
              <Route path="/" element={<LoginPage />} />
              <Route path="/administracion/*" element={<AdminDashboard />} />
              <Route path="/ventas/*" element={<VentasDashboard />} />
              {/* Otras rutas */}
            </Routes>
          </Router>
        </DollarProvider>
      </ToastProvider>
    </ThemeProvider>
  );
}

export default App;
