// src/context/DollarContext.js
import React, { createContext, useState, useEffect, useContext } from "react";
import { toast } from "react-toastify";

const DollarContext = createContext();

export const DollarProvider = ({ children }) => {
  const [dollarPrice, setDollarPrice] = useState(null);

  useEffect(() => {
    const fetchDollarPrice = async () => {
      try {
        const response = await fetch(
          "https://ve.dolarapi.com/v1/dolares/oficial"
        );
        const data = await response.json();
        setDollarPrice(data.promedio);
      } catch (error) {
        console.error("Error fetching dollar price:", error);
        //toast.error("No se pudo obtener el precio del dólar.");
      }
    };
    fetchDollarPrice();
  }, []);

  return (
    <DollarContext.Provider value={{ dollarPrice }}>
      {children}
    </DollarContext.Provider>
  );
};

export const useDollar = () => useContext(DollarContext);
