import React, { useState } from "react";
import {
  Box,
  TextField,
  Button,
  Typography,
  Toolbar,
  AppBar,
} from "@mui/material";
import axios from "axios";
import { toast } from "react-toastify";
import Footer from "../components/Footer";

const CrearAdminForm = ({ apiUrl, onCreated }) => {
  const [form, setForm] = useState({
    username: "",
    email: "",
    password: "",
    rol: "administrador",
  });
  const [loading, setLoading] = useState(false);

  const handleChange = (e) => {
    setForm({ ...form, [e.target.name]: e.target.value });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);

    try {
      await axios.post(`${apiUrl}/api/v1/crear-admin`, form);
      toast.success("Administrador creado correctamente.");

      // Esperar 2 segundos antes de continuar
      setTimeout(() => {
        if (onCreated) onCreated();
      }, 2000); // 2000 milisegundos = 2 segundos
    } catch (error) {
      const message =
        error.response?.data?.detail || "Error al crear el administrador.";
      toast.error(message);
    } finally {
      setLoading(false);
    }
  };

  return (
    <>
      <AppBar position="static" sx={{ backgroundColor: "#0A4575" }}>
        <Toolbar>
          <img
            src="https://www.cementeriopuertasalcielo.com/wp-content/uploads/2023/02/Logo2x-03-1.webp"
            alt="Logo"
            style={{
              width: "270px",
              marginTop: "15px",
              marginBottom: "15px",
              marginRight: "20px",
            }}
          />
          <Box sx={{ flexGrow: 1 }} />
        </Toolbar>
      </AppBar>
      <Box
        sx={{
          backgroundImage: `url('https://www.cementeriopuertasalcielo.com/wp-content/uploads/2024/01/CW16-scaled.jpg')`,
          backgroundRepeat: "no-repeat",
          backgroundSize: "cover",
          backgroundPosition: "center",
          minHeight: "calc(100vh - 80px)",
          display: "flex",
          justifyContent: "center",
          alignItems: "center",
        }}
      >
        <Box
          sx={{
            display: "flex",
            boxShadow: 3,
            maxWidth: "600px",
            width: "100%",
            backgroundColor: "#fff",
          }}
        >
          <Box
            sx={{
              backgroundColor: "#0A4575",
              display: "flex",
              alignItems: "center",
              justifyContent: "center",
              padding: 2,
              width: "270px",
            }}
          >
            <img
              src="https://www.cementeriopuertasalcielo.com/wp-content/uploads/2023/02/LogoFooter-1.webp"
              alt="Logo del Sistema"
              width="70%"
            />
          </Box>

          <Box
            sx={{
              marginTop: "20px",
              marginBottom: "20px",
              padding: 3,
              flex: 1,
            }}
          >
            <Box component="form" onSubmit={handleSubmit}>
              <Typography variant="h5" textAlign="center" mb={3}>
                Crear Primer Administrador
              </Typography>
              <TextField
                label="Nombre"
                name="username"
                value={form.username}
                onChange={handleChange}
                fullWidth
                margin="normal"
                size="small"
                required
                sx={{ boxShadow: 3 }}
              />
              <TextField
                label="Email"
                name="email"
                type="email"
                value={form.email}
                onChange={handleChange}
                fullWidth
                margin="normal"
                size="small"
                required
                sx={{ boxShadow: 3 }}
              />
              <TextField
                label="Contraseña"
                name="password"
                type="password"
                value={form.password}
                onChange={handleChange}
                fullWidth
                margin="normal"
                size="small"
                required
                sx={{ boxShadow: 3 }}
              />
              <Button
                type="submit"
                variant="contained"
                color="primary"
                fullWidth
                disabled={loading}
                sx={{ mt: 2 }}
              >
                {loading ? "Creando..." : "Crear Administrador"}
              </Button>
            </Box>
          </Box>
        </Box>
      </Box>
      <Box sx={{ position: "fixed", bottom: 0, width: "100%" }}>
        <Footer />
      </Box>
    </>
  );
};

export default CrearAdminForm;
