import React from "react";
import {
  AppBar,
  Toolbar,
  Button,
  Box,
  Avatar,
  Typography,
} from "@mui/material";
import { jwtDecode } from "jwt-decode";
import { useNavigate } from "react-router-dom";
import LogoutIcon from "@mui/icons-material/Logout";
import { toast } from "react-toastify";
import { useDollar } from "../DollarPrice"; // importa el hook

const Header = () => {
  const navigate = useNavigate();
  const { dollarPrice } = useDollar(); // usar el valor del contexto

  const handleLogout = () => {
    toast.info("Cerrando sesión...", { position: "bottom-right" });
    setTimeout(() => {
      localStorage.clear();
      navigate("/");
    }, 3000);
  };

  const token = localStorage.getItem("access_token");
  const decoded = jwtDecode(token);
  let loggedInUser = null;
  loggedInUser = decoded.usuario;

  return (
    <>
      <AppBar position="static" sx={{ backgroundColor: "#0A4575" }}>
        <Toolbar>
          <img
            src="https://www.cementeriopuertasalcielo.com/wp-content/uploads/2023/02/Logo2x-03-1.webp"
            alt="Logo"
            style={{
              width: "270px",
              marginTop: "15px",
              marginBottom: "15px",
              marginRight: "20px",
            }}
          />
          <Box sx={{ flexGrow: 1 }} />

          {/* Mostrar precio del dólar si está disponible */}
          {dollarPrice && (
            <Typography
              sx={{
                fontSize: "18px",
                color: "white",
                marginRight: 4,
                fontWeight: "bold",
              }}
            >
              Dólar BCV: {dollarPrice.toFixed(2)} Bs.
            </Typography>
          )}

          <Button
            sx={{
              color: "white",
              backgroundColor: "#0A4575",
              "&:hover": { backgroundColor: "#000000" },
              marginRight: 2,
            }}
            onClick={handleLogout}
            startIcon={<LogoutIcon />}
          >
            Cerrar Sesión
          </Button>

          <Box sx={{ display: "flex", alignItems: "center", marginLeft: 2 }}>
            <Avatar alt="Usuario" src="/images/avatar.png" />
            <Typography sx={{ color: "white", marginLeft: 1 }}>
              {loggedInUser}
            </Typography>
          </Box>
        </Toolbar>
      </AppBar>
    </>
  );
};

export default Header;
