import React, { useEffect, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import logo from '../assets/images/logo.png'; // Ruta correcta del logo
import { Box } from '@mui/material'; // Opcional para el layout

const LogoAnimation = () => {
  const [opacity, setOpacity] = useState(0); // Estado para controlar la opacidad del logo
  const navigate = useNavigate();

  useEffect(() => {
    // Fade-in del logo (aparece en 4 segundos)
    setTimeout(() => {
      setOpacity(1);
    }, 100); // Iniciar fade-in casi inmediato

    // Fade-out del logo después de que haya aparecido
    setTimeout(() => {
      setOpacity(0);
    }, 4000); // Después de 4 segundos, iniciar fade-out

    // Redirigir a la página de login después de que el logo se haya desvanecido
    setTimeout(() => {
      navigate('/login');
    }, 8000); // Redirigir después de 8 segundos en total
  }, [navigate]);

  return (
    <Box
      sx={{
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        height: '100vh',
        backgroundColor: '#f0f0f0',
      }}
    >
      <img
        src={logo}
        alt="Logo"
        style={{
          width: '300px',
          height: '300px',
          opacity: opacity, // Controlar la opacidad del logo
          transition: 'opacity 4s ease-in-out', // Transición de 4 segundos para el fade-in y fade-out
        }}
      />
    </Box>
  );
};

export default LogoAnimation;
