import React from "react";
import { Routes, Route } from "react-router-dom";
import { Box, CssBaseline } from "@mui/material";
import Header from "../../components/Header";
import Footer from "../../components/Footer";
import fondo from "../../assets/img/fondo.png";
import AdminLayout from "./AdminLayout";
import AdminPage from "./AdminPage";

import GestionarUsuarios from "./GestionarUsuarios";
import GestionarVendedores from "./GestionarVendedores";
import Auditoria from "./Auditoria";

import GestionarSolicitudes from "./AdminSolicitudesPage";
import GestionarContratos from "./ContratosTable";
import GestionarSolicitudesCaducadas from "./SolicitudesTable";

import GestionarCuotas from "./ReportePagosCuotas";
import HistorialPagosDeContado from "./PagosDeContado";
import HistorialPagosFinanciados from "./PagosFinanciados";
import HistorialPagos from "./HistorialPagos";

import GestionarPlanes from "./PlanesTable";
import GestionarParcelas from "./InventarioParcelas";
import GestionarColumbarios from "./SubirInventario";
import GestionarPlanesFunerarios from "./PlanesFunerariosTable";

const AdminDashboard = () => {
  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        minHeight: "100vh",
        backgroundImage: `url(${fondo})`,
        backgroundSize: "cover",
        backgroundPosition: "center",
        backgroundRepeat: "no-repeat",
      }}
    >
      <CssBaseline />
      <Header />
      <Box sx={{ display: "flex", flexGrow: 1 }}>
        <AdminLayout />
        <Box
          component="main"
          sx={{
            flexGrow: 1,
            p: 2,
            overflow: "auto",
          }}
        >
          <Routes>
            <Route index element={<AdminPage />} />
            <Route path="gestionar-usuarios" element={<GestionarUsuarios />} />
            <Route
              path="gestionar-vendedores"
              element={<GestionarVendedores />}
            />
            <Route path="auditoria" element={<Auditoria />} />
            <Route
              path="gestionar-solicitudes"
              element={<GestionarSolicitudes />}
            />
            <Route
              path="gestionar-contratos"
              element={<GestionarContratos />}
            />
            <Route
              path="gestionar-solicitudes-caducadas"
              element={<GestionarSolicitudesCaducadas />}
            />
            <Route path="gestionar-cuotas" element={<GestionarCuotas />} />
            <Route
              path="historial-pagos-contado"
              element={<HistorialPagosDeContado />}
            />
            <Route
              path="historial-pagos-financiados"
              element={<HistorialPagosFinanciados />}
            />
            <Route path="historial-ingresos" element={<HistorialPagos />} />

            <Route path="gestionar-planes" element={<GestionarPlanes />} />
            <Route path="gestionar-parcelas" element={<GestionarParcelas />} />
            <Route
              path="gestionar-columbarios"
              element={<GestionarColumbarios />}
            />
            <Route
              path="gestionar-planes-funerarios"
              element={<GestionarPlanesFunerarios />}
            />
          </Routes>
        </Box>
      </Box>
      <Footer />
    </Box>
  );
};

export default AdminDashboard;
