import React, { useState } from "react";
import {
  List,
  ListItemButton,
  ListItemText,
  Collapse,
  Box,
  Typography,
} from "@mui/material";
import { ExpandLess, ExpandMore } from "@mui/icons-material";
import { Link, useLocation } from "react-router-dom";

const AdminLayout = () => {
  const location = useLocation();
  const [openUsuarios, setOpenUsuarios] = useState(false);
  const [openContratos, setOpenContratos] = useState(false);
  const [openPagos, setOpenPagos] = useState(false);
  const [openPlanes, setOpenPlanes] = useState(false);
  const [openInventario, setOpenInventario] = useState(false);

  const handleUsuariosClick = () => setOpenUsuarios(!openUsuarios);
  const handleContratosClick = () => setOpenContratos(!openContratos);
  const handlePagosClick = () => setOpenPagos(!openPagos);
  const handlePlanesClick = () => setOpenPlanes(!openPlanes);
  const handleInventarioClick = () => setOpenInventario(!openInventario);

  return (
    <Box
      sx={{
        marginLeft: "15px",
        marginTop: "15px",
        marginBottom: "15px",
        width: "100%",
        maxWidth: 350,
        bgcolor: "background.paper",
        borderTopLeftRadius: "8px",
        borderBottomRightRadius: "8px",
      }}
    >
      <List component="nav">
        <Box>
          <Typography
            sx={{
              marginTop: "15px",
              marginBottom: "10px",
              textAlign: "center",
              fontFamily: "Bakbak One, sans-serif",
              color: "#0A4575",
            }}
            variant="h6"
          >
            MENU
          </Typography>
        </Box>

        {/* Usuarios */}
        <ListItemButton onClick={handleUsuariosClick}>
          <ListItemText
            primary="Gestión Usuarios"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openUsuarios ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openUsuarios} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-usuarios"
              selected={
                location.pathname === "/administracion/gestionar-usuarios"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-usuarios"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-usuarios"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Gestionar Usuarios" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-vendedores"
              selected={
                location.pathname === "/administracion/gestionar-vendedores"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-vendedores"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-vendedores"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Gestionar Vendedores" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Contratos */}
        <ListItemButton onClick={handleContratosClick}>
          <ListItemText
            primary="Gestión de Contratos"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openContratos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openContratos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-solicitudes"
              selected={
                location.pathname === "/administracion/gestionar-solicitudes"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-solicitudes"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-solicitudes"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Convertir Solicitudes a Contratos" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-contratos"
              selected={
                location.pathname === "/administracion/gestionar-contratos"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-contratos"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-contratos"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Contratos Activos" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-solicitudes-caducadas"
              selected={
                location.pathname ===
                "/administracion/gestionar-solicitudes-caducadas"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname ===
                  "/administracion/gestionar-solicitudes-caducadas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname ===
                  "/administracion/gestionar-solicitudes-caducadas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitudes Caducadas" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Gestión de Pagos */}
        <ListItemButton onClick={handlePagosClick}>
          <ListItemText
            primary="Gestión de Pagos"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openPagos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openPagos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-cuotas"
              selected={
                location.pathname === "/administracion/gestionar-cuotas"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-cuotas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-cuotas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Historial de Cuotas" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/historial-ingresos"
              selected={
                location.pathname === "/administracion/historial-ingresos"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/historial-ingresos"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/historial-ingresos"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Historial de Ingresos" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Planes */}
        <ListItemButton onClick={handlePlanesClick}>
          <ListItemText
            primary="Gestión de Planes"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openPlanes ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openPlanes} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-planes"
              selected={
                location.pathname === "/administracion/gestionar-planes"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-planes"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-planes"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Gestionar Planes" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-parcelas"
              selected={
                location.pathname === "/administracion/gestionar-parcelas"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-parcelas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-parcelas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Gestionar Parcelas" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/administracion/gestionar-columbarios"
              selected={
                location.pathname === "/administracion/gestionar-columbarios"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/administracion/gestionar-columbarios"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/administracion/gestionar-columbarios"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": {
                  bgcolor: "#e2eef7",
                  color: "#000000",
                },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
                "&.Mui-selected:hover": {
                  bgcolor: "#0A4575",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Gestionar Columbarios" />
            </ListItemButton>
          </List>
        </Collapse>
      </List>
    </Box>
  );
};

export default AdminLayout;
