import React, { useState, useEffect } from "react";
import axios from "axios";
import {
  Box,
  Typography,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableHead,
  TableRow,
  Paper,
  Button,
} from "@mui/material";
import { toast } from "react-toastify";
import { Link } from "react-router-dom";
const apiUrl = process.env.REACT_APP_API_URL;

const EstadoCuotas = () => {
  const [cuotas, setCuotas] = useState([]);
  const token = localStorage.getItem("access_token");

  useEffect(() => {
    fetchCuotas();
  }, []);

  const fetchCuotas = async () => {
    try {
      const response = await axios.get(`${apiUrl}/api/contratos/cuotas/all`, {
        headers: { Authorization: `Bearer ${token}` },
      });
      setCuotas(response.data);
    } catch (error) {
      toast.error("Error al cargar el estado de cuotas.");
    }
  };

  const getCuotaColor = (fechaVencimiento, pagado) => {
    const hoy = new Date();
    const vencimiento = new Date(fechaVencimiento);
    if (pagado) return "#90EE90"; // Verde para pagado
    if (vencimiento < hoy) return "#FF6347"; // Rojo para vencido
    return "#FFFFE0"; // Amarillo/gris para pendiente
  };

  return (
    <Box
      sx={{
        maxWidth: "950px",
        margin: "0 auto",
        padding: 3,
        boxShadow: 3,
        backgroundColor: "#ffffff",
        borderRadius: 2,
      }}
    >
      <Typography
        sx={{
          textAlign: "center",
          fontFamily: "Bakbak One, sans-serif",
          color: "#0A4575",
          mb: 4,
        }}
        variant="h6"
      >
        ESTADO DE CUOTAS
      </Typography>
      <TableContainer component={Paper}>
        <Table>
          <TableHead sx={{ backgroundColor: "#0A4575", color: "#FFFFFF" }}>
            <TableRow>
              <TableCell sx={{ color: "#FFFFFF", fontSize: "16px" }}>
                Contrato
              </TableCell>
              <TableCell sx={{ color: "#FFFFFF", fontSize: "16px" }}>
                Cliente
              </TableCell>
              <TableCell sx={{ color: "#FFFFFF", fontSize: "16px" }}>
                Fecha Vencimiento
              </TableCell>
              <TableCell sx={{ color: "#FFFFFF", fontSize: "16px" }}>
                Monto
              </TableCell>
              <TableCell sx={{ color: "#FFFFFF", fontSize: "16px" }}>
                Estado
              </TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {cuotas.map((cuota) => (
              <TableRow
                key={cuota.id}
                sx={{
                  backgroundColor: getCuotaColor(
                    cuota.fecha_vencimiento,
                    cuota.pagado
                  ),
                }}
              >
                <TableCell>{cuota.contrato_id}</TableCell>
                <TableCell>{cuota.cliente_nombre}</TableCell>
                <TableCell>
                  {new Date(cuota.fecha_vencimiento).toLocaleDateString()}
                </TableCell>
                <TableCell>${cuota.monto}</TableCell>
                <TableCell>{cuota.pagado ? "Pagado" : "Pendiente"}</TableCell>
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </TableContainer>
      <Box sx={{ mt: 3, textAlign: "right" }}>
        <Button
          variant="contained"
          component={Link}
          to="/admin"
          sx={{
            backgroundColor: "#0A4575",
            "&:hover": { backgroundColor: "#083a5e" },
          }}
        >
          Volver
        </Button>
      </Box>
    </Box>
  );
};

export default EstadoCuotas;
