import React, { useState } from "react";
import { Box, Typography, Button, Grid, CircularProgress } from "@mui/material";
import axios from "axios";
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

const apiUrl = process.env.REACT_APP_API_URL;

const SubirInventario = () => {
  const [columbarioLado1Img, setColumbarioLado1Img] = useState(null);
  const [columbarioLado2Img, setColumbarioLado2Img] = useState(null);
  const [columbarioLado3Img, setColumbarioLado3Img] = useState(null);
  const [columbarioLado4Img, setColumbarioLado4Img] = useState(null);
  const [loading, setLoading] = useState(false);

  const handleFileChange = (event, setImage) => {
    const file = event.target.files[0];
    if (file && file.type.startsWith("image/")) {
      setImage(file);
    } else {
      toast.error("Por favor, selecciona un archivo de imagen válido.");
    }
  };

  const handleSubmit = async (event) => {
    event.preventDefault();

    if (
      !columbarioLado1Img &&
      !columbarioLado2Img &&
      !columbarioLado3Img &&
      !columbarioLado4Img
    ) {
      toast.error("Debes subir al menos una imagen antes de enviar.");
      return;
    }

    setLoading(true);
    const formData = new FormData();
    if (columbarioLado1Img)
      formData.append("columbario_lado1", columbarioLado1Img);
    if (columbarioLado2Img)
      formData.append("columbario_lado2", columbarioLado2Img);
    if (columbarioLado3Img)
      formData.append("columbario_lado3", columbarioLado3Img);
    if (columbarioLado4Img)
      formData.append("columbario_lado4", columbarioLado4Img);

    try {
      const token = localStorage.getItem("access_token");
      const config = {
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "multipart/form-data",
        },
      };

      await axios.post(`${apiUrl}/api/upload/inventario`, formData, config);
      toast.success("Imágenes actualizadas exitosamente.");
      setColumbarioLado1Img(null);
      setColumbarioLado2Img(null);
      setColumbarioLado3Img(null);
      setColumbarioLado4Img(null);
    } catch (error) {
      console.error(
        "Error al subir las imágenes:",
        error.response?.data || error.message
      );
      toast.error("Error al actualizar las imágenes.");
    } finally {
      setLoading(false);
    }
  };

  return (
    <Box
      elevation={3}
      sx={{
        margin: "0 auto",
        padding: 3,
        boxShadow: 3,
        backgroundColor: "#ffffff",
        borderRadius: 2,
      }}
    >
      <Typography
        sx={{
          fontFamily: "Bakbak One, sans-serif",
          color: "#0A4575",
          mb: 4,
        }}
        variant="h6"
        gutterBottom
      >
        SUBIR INVENTARIO
      </Typography>

      <form onSubmit={handleSubmit}>
        <Grid container spacing={3} direction="column">
          {/* Columbarios en 2 filas de 2 columnas */}
          <Grid item container spacing={2}>
            {[1, 2, 3, 4].map((lado, index) => {
              const setImg = [
                setColumbarioLado1Img,
                setColumbarioLado2Img,
                setColumbarioLado3Img,
                setColumbarioLado4Img,
              ][index];
              const img = [
                columbarioLado1Img,
                columbarioLado2Img,
                columbarioLado3Img,
                columbarioLado4Img,
              ][index];

              return (
                <Grid
                  item
                  xs={12}
                  sm={6}
                  key={lado}
                  container
                  spacing={2}
                  alignItems="center"
                >
                  <Grid item xs={6}>
                    <Button
                      variant="contained"
                      component="label"
                      color="primary"
                      fullWidth
                    >
                      Subir Columbario Lado {lado}
                      <input
                        type="file"
                        hidden
                        accept="image/*"
                        onChange={(e) => handleFileChange(e, setImg)}
                      />
                    </Button>
                  </Grid>
                  <Grid item xs={6}>
                    {img && (
                      <Typography sx={{ fontWeight: "bold" }}>
                        Archivo: {img.name}
                      </Typography>
                    )}
                  </Grid>
                </Grid>
              );
            })}
          </Grid>

          {/* Botón de envío */}
          <Box display="flex" justifyContent="flex-end">
            <Button
              type="submit"
              variant="contained"
              color="primary"
              disabled={loading}
              sx={{ mt: 4 }}
            >
              {loading ? <CircularProgress size={24} /> : "Subir Imágenes"}
            </Button>
          </Box>
        </Grid>
      </form>
    </Box>
  );
};

export default SubirInventario;
