import React, { useState, useEffect } from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableHead,
  TableRow,
  Box,
  Typography,
} from "@mui/material";

const parentesco = [
  { id: 1, parentesco: "Madre/Padre" },
  { id: 2, parentesco: "Hermano/Hermana" },
  { id: 3, parentesco: "Esposo/Esposa" },
  { id: 4, parentesco: "Hijo/Hija" },
  { id: 5, parentesco: "Abuelo/Abuela" },
  { id: 6, parentesco: "Sobrino/Sobrina" },
  { id: 7, parentesco: "Tío/Tía" },
  { id: 8, parentesco: "Otro" },
];

const formatDate = (dateString) => {
  const date = new Date(dateString);
  return date.toLocaleDateString("es-ES", {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
  });
};

const parentescoMap = {};
parentesco.forEach((item) => {
  parentescoMap[item.id] = item.parentesco;
});

export const TablasEmail = ({
  cliente,
  solicitud,
  detalles,
  reportePagos,
  tipoServicio,
  difunto,
}) => {
  const renderTable = () => {
    if (!detalles || detalles.length === 0) {
      return <p>No hay detalles disponibles.</p>;
    }

    const renderReportePagos = () => {
      // Calcular los totales acumulados en USD y VES
      const totalUSD = reportePagos.reduce(
        (sum, pago) => sum + (pago.divisas || 0),
        0
      );
      const totalVES = reportePagos.reduce(
        (sum, pago) => sum + (pago.bolivares || 0),
        0
      );
      console.log(solicitud);
      console.log(reportePagos);
      return (
        <>
          {/* Tabla de Reporte de Pagos */}
          <Box sx={{ marginTop: "10px" }}>
            <Typography
              sx={{
                marginBottom: "10px",
                textAlign: "left",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              }}
              variant="h6"
              gutterBottom
            >
              REPORTE DE PAGO
            </Typography>
            <TableContainer>
              <Table size="small">
                <TableHead>
                  <TableRow sx={{ backgroundColor: "#0A4575" }}>
                    <TableCell
                      sx={{
                        textAlign: "center",
                        color: "#FFFFFF",
                        paddingTop: "8px",
                        paddingBottom: "8px",
                        fontSize: "16px",
                      }}
                    >
                      Fecha de Pago
                    </TableCell>
                    <TableCell
                      sx={{
                        textAlign: "center",
                        color: "#FFFFFF",
                        paddingTop: "8px",
                        paddingBottom: "8px",
                        fontSize: "16px",
                      }}
                    >
                      Método de Pago
                    </TableCell>
                    <TableCell
                      sx={{
                        textAlign: "center",
                        color: "#FFFFFF",
                        paddingTop: "8px",
                        paddingBottom: "8px",
                        fontSize: "16px",
                      }}
                    >
                      Banco Receptor
                    </TableCell>
                    <TableCell
                      sx={{
                        textAlign: "center",
                        color: "#FFFFFF",
                        paddingTop: "8px",
                        paddingBottom: "8px",
                        fontSize: "16px",
                      }}
                    >
                      Banco Emisor
                    </TableCell>
                    <TableCell
                      sx={{
                        textAlign: "center",
                        color: "#FFFFFF",
                        paddingTop: "8px",
                        paddingBottom: "8px",
                        fontSize: "16px",
                      }}
                    >
                      Referencia
                    </TableCell>
                  </TableRow>
                </TableHead>
                <TableBody>
                  {reportePagos && reportePagos.length > 0 ? (
                    reportePagos.map((pago) => (
                      <TableRow key={pago.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {formatDate(pago.fecha_pago)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {pago.metodo_pago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {pago.banco_receptor || "N/A"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {pago.banco_emisor || "N/A"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {pago.referencia || "N/A"}
                        </TableCell>
                      </TableRow>
                    ))
                  ) : (
                    <TableRow>
                      <TableCell colSpan={5} sx={{ textAlign: "center" }}>
                        No hay pagos registrados.
                      </TableCell>
                    </TableRow>
                  )}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>

          {/* Tabla de Totales Acumulados */}
          {reportePagos && reportePagos.length > 0 && (
            <Box sx={{ marginTop: "10px" }}>
              <Typography
                sx={{
                  marginBottom: "10px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                TOTALES PAGADOS
              </Typography>
              <TableContainer>
                <Table size="small">
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Total en USD
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Total en VES
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Dollar BCV
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Total Pagado
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    <TableRow>
                      <TableCell sx={{ textAlign: "center" }}>
                        ${totalUSD.toFixed(2)}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {totalVES.toFixed(2)} Bs.
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>{} Bs.</TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        $
                        {reportePagos
                          .reduce(
                            (sum, pago) => sum + (pago.monto_total || 0),
                            0
                          )
                          .toFixed(2)}
                      </TableCell>
                    </TableRow>
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
          )}
        </>
      );
    };

    switch (tipoServicio) {
      case "previsivo":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table size="small">
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>

                {cliente.familiares && cliente.familiares.length > 0 && (
                  <Box sx={{ marginTop: "20px" }}>
                    <Typography
                      sx={{
                        marginBottom: "10px",
                        textAlign: "left",
                        fontFamily: "Bakbak One, sans-serif",
                        color: "#0A4575",
                      }}
                      variant="h6"
                      gutterBottom
                    >
                      FAMILIARES
                    </Typography>
                    <TableContainer component={Box}>
                      <Table>
                        <TableHead>
                          <TableRow sx={{ backgroundColor: "#0A4575" }}>
                            <TableCell
                              sx={{
                                textAlign: "center",
                                color: "#FFFFFF",
                                paddingTop: "8px",
                                paddingBottom: "8px",
                                fontSize: "16px",
                              }}
                            >
                              Nombre y Apellido
                            </TableCell>
                            <TableCell
                              sx={{
                                textAlign: "center",
                                color: "#FFFFFF",
                                paddingTop: "8px",
                                paddingBottom: "8px",
                                fontSize: "16px",
                              }}
                            >
                              Cédula de Identidad
                            </TableCell>
                            <TableCell
                              sx={{
                                textAlign: "center",
                                color: "#FFFFFF",
                                paddingTop: "8px",
                                paddingBottom: "8px",
                                fontSize: "16px",
                              }}
                            >
                              Fecha de Nacimiento
                            </TableCell>
                            <TableCell
                              sx={{
                                textAlign: "center",
                                color: "#FFFFFF",
                                paddingTop: "8px",
                                paddingBottom: "8px",
                                fontSize: "16px",
                              }}
                            >
                              Edad
                            </TableCell>
                            <TableCell
                              sx={{
                                textAlign: "center",
                                color: "#FFFFFF",
                                paddingTop: "8px",
                                paddingBottom: "8px",
                                fontSize: "16px",
                              }}
                            >
                              Parentesco
                            </TableCell>
                          </TableRow>
                        </TableHead>
                        <TableBody>
                          {cliente.familiares.map((familiar) => (
                            <TableRow key={familiar.id}>
                              <TableCell sx={{ textAlign: "center" }}>
                                {familiar.nombre}
                              </TableCell>
                              <TableCell sx={{ textAlign: "center" }}>
                                {familiar.cedula}
                              </TableCell>
                              <TableCell sx={{ textAlign: "center" }}>
                                {formatDate(familiar.fecha_nacimiento)}
                              </TableCell>
                              <TableCell sx={{ textAlign: "center" }}>
                                {familiar.edad}
                              </TableCell>
                              <TableCell sx={{ textAlign: "center" }}>
                                {familiar.parentesco}
                              </TableCell>
                            </TableRow>
                          ))}
                        </TableBody>
                      </Table>
                    </TableContainer>
                  </Box>
                )}
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Tipo de Contrato
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {solicitud.detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_contrato || "N/A"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.pagoInicial}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.montoPorCuota}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.precioTotal || 0}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "Servicio Funerario":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "20px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Traslado
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Tiempo de Velación
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Velación
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Preparación
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Alquiler Ataúd
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => {
                      const detallesAdicionales =
                        detalle.detalles_adicionales || {};
                      return (
                        <TableRow key={detalle.id}>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detalle.descripcion}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            $
                            {detallesAdicionales.traslado?.toFixed(2) || "0.00"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detallesAdicionales.tiempo_velacion || "-"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            $
                            {detallesAdicionales.precio_velacion?.toFixed(2) ||
                              "0.00"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            ${detallesAdicionales.incluye_preparacion}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            $
                            {detallesAdicionales.incluye_ataud?.toFixed(2) ||
                              "0"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            ${detalle.precioTotal?.toFixed(2) || "0"}
                          </TableCell>
                        </TableRow>
                      );
                    })}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {difunto && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL DIFUNTO
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Fecha de Nacimiento
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Edad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Parentesco
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Fecha de Defunción
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Causa de Defunción
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección de Defunción
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {difunto.nombre_difunto}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {difunto.cedula_difunto}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {formatDate(difunto.fecha_nac_difunto)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {difunto.edad_difunto}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {parentescoMap[difunto.parentesco_difunto] ||
                            difunto.parentesco_difunto}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {formatDate(difunto.fecha_defuncion)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {difunto.causa_defuncion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {difunto.direccion_defuncion}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            {renderReportePagos()}
          </>
        );

      case "parcelas":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles && detalles.length > 0 ? (
                      detalles.map((detalle) => (
                        <TableRow key={detalle.codigo}>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detalle.codigo || "N/A"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detalle.descripcion || "N/A"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detalle.modalidadPago || "N/A"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            ${detalle.pagoInicial?.toFixed(2) || "0.00"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            {detalle.cuotas || 0}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            ${detalle.montoPorCuota?.toFixed(2) || "0.00"}
                          </TableCell>
                          <TableCell sx={{ textAlign: "center" }}>
                            ${detalle.precioTotal?.toFixed(2) || "0.00"}
                          </TableCell>
                        </TableRow>
                      ))
                    ) : (
                      <TableRow>
                        <TableCell colSpan={7} sx={{ textAlign: "center" }}>
                          No hay detalles disponibles.
                        </TableCell>
                      </TableRow>
                    )}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "nichos-columbarios":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Plan
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.codigo_nicho}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.precio?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.pagoInicial?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.montoPorCuota?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.precioTotal?.toFixed(2) || "0.00"}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "nichos-ataud":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "10px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Plan
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.codigo_nicho}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.precio?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.pagoInicial?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.montoPorCuota?.toFixed(2) || "0.00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle.precioTotal?.toFixed(2) || "0.00"}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "cremacion":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "10px" }}>
                <Typography
                  sx={{
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table size="small">
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table size="small">
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Financiado
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descuento
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio con Descuento
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.codigo}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center", width: "10%" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle.pagoInicial.toFixed(2)}{" "}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle.montoPorCuotas}{" "}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle?.precioFinanciado.toFixed(2)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle?.descuento || "0,00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle?.precioConDescuento || "0,00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle.precioPlan}{" "}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "honra-exequias":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Financiado
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descuento
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.codigo}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                          {detalle.pagoInicial.toFixed(2)}{" "}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES"
                            ? `Bs. ${detalle.montoPorCuotas}`
                            : `$ ${detalle.montoPorCuotas}`}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle?.precioFinanciado.toFixed(2)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle?.descuento || "0,00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}{" "}
                          {detalle.precioPlan}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      case "inhumacion-parcelas":
        return (
          <>
            {cliente && (
              <Box sx={{ marginBottom: "40px" }}>
                <Typography
                  sx={{
                    marginTop: "20px",
                    textAlign: "left",
                    fontFamily: "Bakbak One, sans-serif",
                    color: "#0A4575",
                  }}
                  variant="h6"
                  gutterBottom
                >
                  DATOS DEL CLIENTE
                </Typography>
                <TableContainer>
                  <Table>
                    <TableHead>
                      <TableRow sx={{ backgroundColor: "#0A4575" }}>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Nombre y Apellido
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Cédula de Identidad
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Dirección
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Celular
                        </TableCell>
                        <TableCell
                          sx={{
                            textAlign: "center",
                            paddingTop: "8px",
                            paddingBottom: "8px",
                            color: "#FFFFFF",
                            fontSize: "16px",
                          }}
                        >
                          Correo Electrónico
                        </TableCell>
                      </TableRow>
                    </TableHead>
                    <TableBody>
                      <TableRow>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.nombre}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.cedula}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.direccion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.celular}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {cliente.email}
                        </TableCell>
                      </TableRow>
                    </TableBody>
                  </Table>
                </TableContainer>
              </Box>
            )}
            <Box>
              <Typography
                sx={{
                  marginTop: "20px",
                  textAlign: "left",
                  fontFamily: "Bakbak One, sans-serif",
                  color: "#0A4575",
                }}
                variant="h6"
                gutterBottom
              >
                DETALLES DE LA SOLICITUD DE CONTRATO
              </Typography>
              <TableContainer>
                <Table>
                  <TableHead>
                    <TableRow sx={{ backgroundColor: "#0A4575" }}>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Código
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descripción
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Modalidad de Pago
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Pago Inicial
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Monto Cuotas
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Financiado
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Descuento
                      </TableCell>
                      <TableCell
                        sx={{
                          textAlign: "center",
                          color: "#FFFFFF",
                          paddingTop: "8px",
                          paddingBottom: "8px",
                          fontSize: "16px",
                        }}
                      >
                        Precio Total
                      </TableCell>
                    </TableRow>
                  </TableHead>
                  <TableBody>
                    {detalles.map((detalle) => (
                      <TableRow key={detalle.id}>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.codigo}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.descripcion}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {solicitud?.modalidadPago}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.pagoInicial.toFixed(2)}{" "}
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.cuotas}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.montoPorCuotas}{" "}
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle?.precioFinanciado.toFixed(2)}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          ${detalle?.descuento || "0,00"}
                        </TableCell>
                        <TableCell sx={{ textAlign: "center" }}>
                          {detalle.precioPlan}{" "}
                          {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                        </TableCell>
                      </TableRow>
                    ))}
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
            {renderReportePagos()}
          </>
        );

      default:
        return (
          <>
            <p>No hay detalles disponibles para este tipo de servicio.</p>
            {renderReportePagos()}
          </>
        );
    }
  };

  return <div>{renderTable()}</div>;
};
