// MenuVendedor.js
import React, { useState } from 'react';
import {
  List,
  ListItemButton,
  ListItemIcon,
  ListItemText,
  Collapse,
  Box,
} from '@mui/material';
import {
  ExpandLess,
  ExpandMore,
  ShoppingCart,
  Build,
  Receipt,
  Assessment,
} from '@mui/icons-material';

import { Link, useLocation } from 'react-router-dom';

const VentasLayout = () => {
  const [openProductos, setOpenProductos] = useState(false);
  const [openServicios, setOpenServicios] = useState(false);
  const [openPedidos, setOpenPedidos] = useState(false);
  const [openReportes, setOpenReportes] = useState(false);

  const location = useLocation();

  const handleProductosClick = () => {
    setOpenProductos(!openProductos);
  };

  const handleServiciosClick = () => {
    setOpenServicios(!openServicios);
  };

  const handlePedidosClick = () => {
    setOpenPedidos(!openPedidos);
  };

  const handleReportesClick = () => {
    setOpenReportes(!openReportes);
  };

  return (
    <Box sx={{ marginLeft: '15px', marginTop: '10px', width: '100%', maxWidth: 250, bgcolor: 'background.paper' }}>
      <List component="nav">
        {/* Productos */}
        <ListItemButton onClick={handleProductosClick}>
          <ListItemIcon>
            <ShoppingCart />
          </ListItemIcon>
          <ListItemText primary="Productos" />
          {openProductos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openProductos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton component={Link} to="/vendedor/columbarios" selected={location.pathname === '/vendedor/columbarios'} sx={{ pl: 4 }}>
              <ListItemText primary="Nichos de Columbarios" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/productos/nichos-ataud" sx={{ pl: 4 }}>
              <ListItemText primary="Nichos de Ataud" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/productos/parcelas" sx={{ pl: 4 }}>
              <ListItemText primary="Parcelas" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Servicios */}
        <ListItemButton onClick={handleServiciosClick}>
          <ListItemIcon>
            <Build />
          </ListItemIcon>
          <ListItemText primary="Servicios" />
          {openServicios ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openServicios} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton component={Link} to="/vendedor/servicios/cremacion" sx={{ pl: 4 }}>
              <ListItemText primary="Cremación" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/servicios/funerarios" sx={{ pl: 4 }}>
              <ListItemText primary="Funerarios" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/servicios/certificado-funerario" sx={{ pl: 4 }}>
              <ListItemText primary="Certificado Funerario" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/servicios/previsivos" sx={{ pl: 4 }}>
              <ListItemText primary="Previsivos" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Pedidos */}
        <ListItemButton onClick={handlePedidosClick}>
          <ListItemIcon>
            <Receipt />
          </ListItemIcon>
          <ListItemText primary="Pedidos" />
          {openPedidos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openPedidos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton component={Link} to="/ventas/nuevo-contrato" selected={location.pathname === '/ventas/nuevo-contrato'} sx={{ pl: 4 }}>
              <ListItemText primary="Nuevo Contrato" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/formulario-cliente" selected={location.pathname === '/vendedor/formulario-cliente'} sx={{ pl: 4 }}>
              <ListItemText primary="Formulario Cliente" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/facturar" sx={{ pl: 4 }}>
              <ListItemText primary="Facturar Productos / Servicios" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/financiamiento" sx={{ pl: 4 }}>
              <ListItemText primary="Financiamiento" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/cerrar-venta" sx={{ pl: 4 }}>
              <ListItemText primary="Cerrar Venta" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Reportes */}
        <ListItemButton onClick={handleReportesClick}>
          <ListItemIcon>
            <Assessment />
          </ListItemIcon>
          <ListItemText primary="Reportes" />
          {openReportes ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openReportes} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton component={Link} to="/vendedor/reportes/clientes" sx={{ pl: 4 }}>
              <ListItemText primary="Clientes" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/reportes/ventas" sx={{ pl: 4 }}>
              <ListItemText primary="Ventas" />
            </ListItemButton>
            <ListItemButton component={Link} to="/vendedor/reportes/cobranza" sx={{ pl: 4 }}>
              <ListItemText primary="Cobranza" />
            </ListItemButton>
          </List>
        </Collapse>
      </List>
    </Box>
  );
};

export default VentasLayout;
