import React, { useState, useEffect } from 'react';
import { Dialog, DialogTitle, DialogContent, IconButton, Grid, Button } from '@mui/material';
import HelpOutlineIcon from '@mui/icons-material/HelpOutline';
import ArrowBackIosIcon from '@mui/icons-material/ArrowBackIos';
import ArrowForwardIosIcon from '@mui/icons-material/ArrowForwardIos';

const columbarios = [
  { nombre: "Columbario A", url: "/images/columbario-a.jpg" },
  { nombre: "Columbario B", url: "/images/columbario-b.jpg" },
  { nombre: "Columbario C", url: "/images/columbario-c.jpg" },
  { nombre: "Columbario D", url: "/images/columbario-d.jpg" },
];

export default function ModalColumbarios() {
  const [selectedIndex, setSelectedIndex] = useState(0);
  const [isOpen, setIsOpen] = useState(false);

  const handleKeyDown = (e) => {
    if (e.key === "ArrowRight") {
      setSelectedIndex((prev) => (prev + 1) % columbarios.length);
    } else if (e.key === "ArrowLeft") {
      setSelectedIndex((prev) => (prev - 1 + columbarios.length) % columbarios.length);
    }
  };

  useEffect(() => {
    if (isOpen) {
      window.addEventListener("keydown", handleKeyDown);
    } else {
      window.removeEventListener("keydown", handleKeyDown);
    }
    return () => window.removeEventListener("keydown", handleKeyDown);
  }, [isOpen]);

  return (
    <Grid container alignItems="center" spacing={1}>
      <Grid item>
        <IconButton onClick={() => setIsOpen(true)}>
          <HelpOutlineIcon />
        </IconButton>
      </Grid>
      <Dialog open={isOpen} onClose={() => setIsOpen(false)} maxWidth="sm" fullWidth>
        <DialogTitle>Columbarios Disponibles</DialogTitle>
        <DialogContent>
          <Grid container spacing={2} justifyContent="center">
            {columbarios.map((item, index) => (
              <Grid item key={index}>
                <Button
                  variant={selectedIndex === index ? "contained" : "outlined"}
                  onClick={() => setSelectedIndex(index)}
                >
                  {item.nombre}
                </Button>
              </Grid>
            ))}
          </Grid>
          <Grid container justifyContent="center" alignItems="center" spacing={2}>
            <Grid item>
              <IconButton onClick={() => setSelectedIndex((prev) => (prev - 1 + columbarios.length) % columbarios.length)}>
                <ArrowBackIosIcon />
              </IconButton>
            </Grid>
            <Grid item>
              <img
                src={columbarios[selectedIndex].url}
                alt={columbarios[selectedIndex].nombre}
                style={{ width: '300px', height: '300px', objectFit: 'cover', borderRadius: '8px' }}
              />
            </Grid>
            <Grid item>
              <IconButton onClick={() => setSelectedIndex((prev) => (prev + 1) % columbarios.length)}>
                <ArrowForwardIosIcon />
              </IconButton>
            </Grid>
          </Grid>
        </DialogContent>
      </Dialog>
    </Grid>
  );
}
