import React from 'react';
import {
  Box,
  Button,
  Typography,
  TextField,
  Grid
} from '@mui/material';

const PresupuestoForm = ({ cliente, handleClienteChange, handleFileChange }) => {

  return (
    <Box component="form" 
      sx={{
        maxWidth: '950px',
        margin: '0 auto',
        padding: 3,
        boxShadow: 3,
        backgroundColor: '#ffffff',
        borderRadius: 2,
      }}
    >       
      {/* DATOS DEL CLIENTE */}
      <Typography
        sx={{ marginTop: '10px', marginBottom: '5px', fontFamily: 'Bakbak One, sans-serif', color: '#0A4575' }}
        variant="h6"
      >
        DATOS DEL CLIENTE
      </Typography>

      <Grid container spacing={3}>
        <Grid item xs={12} sm={4}>
          <TextField
            fullWidth
            label="Nombre Solicitante *"
            variant="outlined"
            size="small"
            name="solicitante"
            value={cliente.solicitante}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={3}>
          <TextField
            fullWidth
            label="Cédula o Rif *"
            variant="outlined"
            size="small"
            name="cedula"
            value={cliente.cedula}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={3}>
          <TextField
            fullWidth
            label="Fecha de Nacimiento"
            variant="outlined"
            type="date"
            size="small"
            name="fechaNac"
            value={cliente.fechaNac || ''}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
            InputLabelProps={{
              shrink: true,
            }}
          />
        </Grid>
        <Grid item xs={12} sm={2}>
          <TextField
            fullWidth
            label="Edad"
            variant="outlined"
            size="small"
            name="edad"
            value={cliente.edad}
            required
            sx={{ boxShadow: 3 }}
            InputProps={{
              readOnly: true,
            }}
          />
        </Grid>
        <Grid item xs={12} sm={3}>
          <TextField
            fullWidth
            label="Teléfono *"
            variant="outlined"
            size="small"
            name="telefono"
            value={cliente.telefono}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={3}>
          <TextField
            fullWidth
            label="Celular *"
            variant="outlined"
            size="small"
            name="celular"
            value={cliente.celular}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={6}>
          <TextField
            fullWidth
            label="Email *"
            variant="outlined"
            size="small"
            name="correo"
            value={cliente.correo}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={5}>
          <TextField
            fullWidth
            label="Dirección *"
            variant="outlined"
            size="small"
            name="direccion"
            value={cliente.direccion}
            onChange={handleClienteChange}
            required
            sx={{ boxShadow: 3 }}
          />
        </Grid>
        <Grid item xs={12} sm={4}>            
          <input
            accept="image/*" // Puedes restringir el tipo de archivo permitido
            style={{ display: 'none' }} // Ocultar el input real
            id="file-upload"
            type="file"
            onChange={handleFileChange}
          />
          
          <label htmlFor="file-upload">
            <Button
              variant="contained"
              component="span"
              sx={{
                backgroundColor: '#0A4575',
                color: '#FFFFFF',
                '&:hover': {
                  backgroundColor: '#083a5e',
                },
              }}
            >
              Subir Documento de Identidad
            </Button>
          </label>
        </Grid>
        <Grid item xs={12} sm={3}>
          {/* Mostrar el nombre del archivo seleccionado */}
          {cliente.fileName && (
            <Typography sx={{ marginTop: '10px', fontFamily: 'Abel' }}>
              Documento: {cliente.fileName}
            </Typography>
          )}            
        </Grid>
      </Grid>
    </Box>
  );
};

export default PresupuestoForm;
