import React, { useState, useEffect } from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableHead,
  TableRow,
  Box,
  Typography,
} from "@mui/material";

// Define parentesco and parentescoMap at the top level
const parentesco = [
  { id: 1, parentesco: "Madre/Padre" },
  { id: 2, parentesco: "Hermano/Hermana" },
  { id: 3, parentesco: "Esposo/Esposa" },
  { id: 4, parentesco: "Hijo/Hija" },
  { id: 5, parentesco: "Abuelo/Abuela" },
  { id: 6, parentesco: "Sobrino/Sobrina" },
  { id: 7, parentesco: "Tío/Tía" },
  { id: 8, parentesco: "Otro" },
];

const parentescoMap = {};
parentesco.forEach((item) => {
  parentescoMap[item.id] = item.parentesco;
});

// Define formatDate at the top level
const formatDate = (dateString) => {
  const date = new Date(dateString);
  return date.toLocaleDateString("es-ES", {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
  });
};

export const TablasEmail = ({
  cliente,
  solicitud,
  detalles,
  reportePagos,
  difunto,
}) => {
  const [precioConDescuento, setPrecioConDescuento] = useState(0);

  useEffect(() => {
    {
      detalles.map((detalle) =>
        setPrecioConDescuento(detalle.precioPlan - detalle.descuento)
      );
    }
  });

  return (
    <>
      {cliente && (
        <Box sx={{ marginBottom: "10px" }}>
          <Typography
            sx={{
              textAlign: "left",
              fontFamily: "Bakbak One, sans-serif",
              color: "#0A4575",
            }}
            variant="h6"
            gutterBottom
          >
            DATOS DEL CLIENTE
          </Typography>
          <TableContainer>
            <Table size="small">
              <TableHead>
                <TableRow sx={{ backgroundColor: "#0A4575" }}>
                  <TableCell
                    sx={{
                      textAlign: "center",
                      paddingTop: "8px",
                      paddingBottom: "8px",
                      color: "#FFFFFF",
                      fontSize: "16px",
                    }}
                  >
                    Nombre y Apellido
                  </TableCell>
                  <TableCell
                    sx={{
                      textAlign: "center",
                      paddingTop: "8px",
                      paddingBottom: "8px",
                      color: "#FFFFFF",
                      fontSize: "16px",
                    }}
                  >
                    Cédula de Identidad
                  </TableCell>
                  <TableCell
                    sx={{
                      textAlign: "center",
                      paddingTop: "8px",
                      paddingBottom: "8px",
                      color: "#FFFFFF",
                      fontSize: "16px",
                    }}
                  >
                    Dirección
                  </TableCell>
                  <TableCell
                    sx={{
                      textAlign: "center",
                      paddingTop: "8px",
                      paddingBottom: "8px",
                      color: "#FFFFFF",
                      fontSize: "16px",
                    }}
                  >
                    Celular
                  </TableCell>
                  <TableCell
                    sx={{
                      textAlign: "center",
                      paddingTop: "8px",
                      paddingBottom: "8px",
                      color: "#FFFFFF",
                      fontSize: "16px",
                    }}
                  >
                    Correo Electrónico
                  </TableCell>
                </TableRow>
              </TableHead>
              <TableBody>
                <TableRow>
                  <TableCell sx={{ textAlign: "center" }}>
                    {cliente.nombre}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {cliente.cedula}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {cliente.direccion}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {cliente.celular}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {cliente.email}
                  </TableCell>
                </TableRow>
              </TableBody>
            </Table>
          </TableContainer>
        </Box>
      )}
      <Box>
        <Typography
          sx={{
            textAlign: "left",
            fontFamily: "Bakbak One, sans-serif",
            color: "#0A4575",
          }}
          variant="h6"
          gutterBottom
        >
          DETALLES DE LA SOLICITUD DE CONTRATO
        </Typography>
        <TableContainer>
          <Table size="small">
            <TableHead>
              <TableRow sx={{ backgroundColor: "#0A4575" }}>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Código
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Descripción
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Modalidad de Pago
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Pago Inicial
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Cuotas
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Monto Cuotas
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Precio Financiado
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Descuento
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Precio con Descuento
                </TableCell>
                <TableCell
                  sx={{
                    textAlign: "center",
                    color: "#FFFFFF",
                    paddingTop: "8px",
                    paddingBottom: "8px",
                    fontSize: "16px",
                  }}
                >
                  Precio Total
                </TableCell>
              </TableRow>
            </TableHead>
            <TableBody>
              {detalles.map((detalle) => (
                <TableRow key={detalle.id}>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.codigo}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {solicitud?.descripcion}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {solicitud?.modalidadPago}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center", width: "10%" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle.pagoInicial.toFixed(2)}{" "}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.cuotas}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle.montoPorCuotas}{" "}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle?.precioFinanciado.toFixed(2)}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle?.descuento || "0,00"}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle.precioConDescuento || "0,00"}
                  </TableCell>
                  <TableCell sx={{ textAlign: "center" }}>
                    {detalle.tipo_moneda === "VES" ? "Bs." : "$"}
                    {detalle.precioPlan}{" "}
                  </TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        </TableContainer>
      </Box>

      <Box sx={{ marginTop: "20px" }}>
        <Typography
          sx={{ fontFamily: "Bakbak One, sans-serif", color: "#0A4575" }}
          variant="h6"
        >
          REPORTE DE PAGO
        </Typography>
        <TableContainer>
          {/* Tabla para USD */}
          {reportePagos.some((p) => p.metodo_pago === "USD") && (
            <Table size="small" sx={{ marginBottom: "20px" }}>
              <TableHead>
                <TableRow sx={{ backgroundColor: "#0A4575" }}>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Fecha
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Método de Pago
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Monto Pagado en Divisas
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Descuento
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Precio Total con Descuento
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Precio Total
                  </TableCell>
                </TableRow>
              </TableHead>
              <TableBody>
                {reportePagos
                  .filter((p) => p.metodo_pago === "USD")
                  .map((p) => (
                    <TableRow key={p.id}>
                      <TableCell sx={{ textAlign: "center" }}>
                        {formatDate(p.fecha_pago)}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago === "USD" ? "$" : "$"}
                        {p.divisas?.toFixed(2) || "0.00"}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago === "USD" ? "$" : "$"}
                        {p.descuento?.toFixed(2) || "0.00"}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago === "USD" ? "$" : "$"}
                        {precioConDescuento.toFixed(2) || "0.00"}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago === "USD" ? "$" : "$"}
                        {p.monto_total?.toFixed(2) || "0.00"}
                      </TableCell>
                    </TableRow>
                  ))}
              </TableBody>
            </Table>
          )}

          {/* Tabla para VES */}
          {reportePagos.some((p) => p.metodo_pago === "VES") && (
            <Table size="small">
              <TableHead>
                <TableRow sx={{ backgroundColor: "#0A4575" }}>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Fecha
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Método de Pago
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Monto Pagado en Bolívares
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Tasa BCV
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Precio Financiado
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Precio Total
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Banco Emisor
                  </TableCell>
                  <TableCell sx={{ color: "#FFF", textAlign: "center" }}>
                    Referencia
                  </TableCell>
                </TableRow>
              </TableHead>
              <TableBody>
                {reportePagos
                  .filter((p) => p.metodo_pago === "VES")
                  .map((p) => (
                    <TableRow key={p.id}>
                      <TableCell sx={{ textAlign: "center" }}>
                        {formatDate(p.fecha_pago)}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.metodo_pago}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.bolivares?.toFixed(2) || "0.00"} Bs
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.dollar_price?.toFixed(2) || "0.00"}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.monto_restante?.toFixed(2) || "0.00"} Bs
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.monto_total?.toFixed(2) || "0.00"} Bs
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.banco_emisor || "N/A"}
                      </TableCell>
                      <TableCell sx={{ textAlign: "center" }}>
                        {p.referencia || "N/A"}
                      </TableCell>
                    </TableRow>
                  ))}
              </TableBody>
            </Table>
          )}
        </TableContainer>
      </Box>
    </>
  );
};
