import React from "react";
import { Routes, Route } from "react-router-dom";
import { Box, CssBaseline } from "@mui/material";
import fondo from "../../assets/img/fondo.png";
import Header from "../../components/Header";
import Footer from "../../components/Footer";

import VentasLayout from "./VentasLayout";
import VentasPage from "./VentasPage";
import VentasContrato from "./Contrato";

import CalcularPlan from "./Prueba_Parcelas";
import ContratoParcelas from "./Parcelas";
import ContratoColumbarios from "./Columbarios";
import ContratoNichosAtaud from "./NichosAtaud";

import ContratoPrevisivos from "./Previsivos";
import ContratoCremacion from "./Cremacion";
import ContratoExequias from "./Exequia";
import ContratoInhumacion from "./Inhumacion";
import ContratoFunerario from "./Funerarios";
import ServicioFunerario from "./ServicioFunerario";

import Solicitudes from "./Solicitudes";
import Contratos from "./ListaContratos";
import Clientes from "./Clientes";
import Vendedores from "./VendedoresList";

import ReportePagos from "./ReportePagosPage";
import ReportePagosCuotas from "./ReportePagosCuotas";
import HistorialPagos from ".//HistorialPagos";

import SubirDocumento from "./SubirDocumento";
import DocumentosFamiliares from "./DocumentosFamiliares";
import Autorizados from "./AutorizadosPage";

import Ayuda from "../ayuda/Ayuda";
import AyudaGeneral from "../ayuda/AyudaGeneral";

const VentasDashboard = () => {
  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        minHeight: "100vh",
        backgroundImage: `url(${fondo})`,
        backgroundSize: "cover",
        backgroundPosition: "center",
        backgroundRepeat: "no-repeat",
      }}
    >
      <CssBaseline />
      <Header />
      <Box sx={{ display: "flex", flexGrow: 1 }}>
        <VentasLayout />
        <Box
          component="main"
          sx={{
            flexGrow: 1,
            mt: 1,
            p: 1,
            overflow: "auto",
          }}
        >
          <Routes>
            <Route index element={<VentasPage />} />
            <Route path="contrato/plan" element={<CalcularPlan />} />
            <Route path="contrato/:producto" element={<VentasContrato />} />
            <Route path="contrato/:producto" element={<ContratoParcelas />} />
            <Route path="contrato/:producto" element={<ContratoCremacion />} />
            <Route path="contrato/:producto" element={<ContratoExequias />} />
            <Route path="contrato/:producto" element={<ContratoInhumacion />} />
            <Route
              path="contrato/:producto"
              element={<ContratoNichosAtaud />}
            />
            <Route path="contrato/previsivo" element={<ContratoPrevisivos />} />
            <Route
              path="contrato/:producto"
              element={<ContratoColumbarios />}
            />
            <Route path="contrato/:producto" element={<ContratoFunerario />} />
            <Route
              path="contrato/servicio-funerario"
              element={<ServicioFunerario />}
            />
            <Route path="/solicitudes" element={<Solicitudes />} />
            <Route path="/contratos" element={<Contratos />} />
            <Route path="/clientes" element={<Clientes />} />
            <Route path="/vendedores" element={<Vendedores />} />
            <Route path="/reporte-pagos" element={<ReportePagos />} />{" "}
            <Route path="/reporte-cuotas" element={<ReportePagosCuotas />} />{" "}
            <Route path="historial-pagos" element={<HistorialPagos />} />
            <Route path="/subir-documento" element={<SubirDocumento />} />
            <Route
              path="/subir-documento-familiar"
              element={<DocumentosFamiliares />}
            />
            <Route path="/autorizados" element={<Autorizados />} />
            {/* Nueva ruta */}
            <Route path="ayuda" element={<Ayuda />} />
            <Route path="ayuda/:temaId" element={<AyudaGeneral />} />
          </Routes>
        </Box>
      </Box>
      <Footer />
    </Box>
  );
};

export default VentasDashboard;
