import React, { useState } from "react";
import {
  List,
  ListItemButton,
  ListItemText,
  Collapse,
  Box,
  Typography,
} from "@mui/material";
import { ExpandLess, ExpandMore } from "@mui/icons-material";
import { Link, useLocation } from "react-router-dom";

const VentasLayout = () => {
  const location = useLocation();
  const [openProductos, setOpenProductos] = useState(false);
  const [openServicios, setOpenServicios] = useState(false);
  const [openPagos, setOpenPagos] = useState(false);
  const [openVentas, setOpenVentas] = useState(false);
  const [openClientes, setOpenClientes] = useState(false);
  const [openAyuda, setOpenAyuda] = useState(false);

  const handleProductosClick = () => setOpenProductos(!openProductos);
  const handleServiciosClick = () => setOpenServicios(!openServicios);
  const handlePagosClick = () => setOpenPagos(!openPagos);
  const handleVentasClick = () => setOpenVentas(!openVentas);
  const handleClienteClick = () => setOpenClientes(!openClientes);
  const handleAyudaClick = () => setOpenAyuda(!openAyuda);
  const rol = localStorage.getItem("rol");
  // Si el rol es 'vendedor', no mostrar la sección de administración
  const isVendedor = rol === "vendedor";
  return (
    <Box
      sx={{
        marginLeft: "10px",
        marginTop: "15px",
        marginBottom: "15px",
        width: "100%",
        maxWidth: 350,
        bgcolor: "background.paper",
        borderTopLeftRadius: "8px",
        borderBottomRightRadius: "8px",
      }}
    >
      <List component="nav">
        <Box>
          <Typography
            sx={{
              marginTop: "15px",
              marginBottom: "10px",
              textAlign: "center",
              fontFamily: "Bakbak One, sans-serif",
              color: "#0A4575",
            }}
            variant="h6"
          >
            MENU
          </Typography>
        </Box>

        {/* Productos */}
        <ListItemButton onClick={handleProductosClick}>
          <ListItemText
            primary="Productos"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openProductos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openProductos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/parcelas"
              selected={location.pathname === "/ventas/contrato/parcelas"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/parcelas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/parcelas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Parcelas" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/nichos-columbarios"
              selected={
                location.pathname === "/ventas/contrato/nichos-columbarios"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/nichos-columbarios"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/nichos-columbarios"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Nichos de Columbarios" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/nichos-ataud"
              selected={location.pathname === "/ventas/contrato/nichos-ataud"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/nichos-ataud"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/nichos-ataud"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Nicho de Ataud" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Servicios */}
        <ListItemButton onClick={handleServiciosClick}>
          <ListItemText
            primary="Servicios"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openServicios ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openServicios} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/cremacion"
              selected={location.pathname === "/ventas/contrato/cremacion"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/cremacion"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/cremacion"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Cremación" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/honra-exequias"
              selected={location.pathname === "/ventas/contrato/honra-exequias"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/honra-exequias"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/honra-exequias"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Honra de Exequias" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/inhumacion-parcelas"
              selected={
                location.pathname === "/ventas/contrato/inhumacion-parcelas"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/inhumacion-parcelas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/inhumacion-parcelas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Inhumación de Parcelas" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/plan-funerario"
              selected={location.pathname === "/ventas/contrato/plan-funerario"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/plan-funerario"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/plan-funerario"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Servicio Funerario" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contrato/previsivo"
              selected={location.pathname === "/ventas/contrato/previsivo"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contrato/previsivo"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contrato/previsivo"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitud de Contrato de Servicio Previsivo" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Gestión de Pagos */}
        <ListItemButton onClick={handlePagosClick}>
          <ListItemText
            primary="Gestión de Pagos"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openPagos ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openPagos} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/reporte-pagos"
              selected={location.pathname === "/ventas/reporte-pagos"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/reporte-pagos"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/reporte-pagos"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Reportes de Pagos" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/reporte-cuotas"
              selected={location.pathname === "/ventas/reporte-cuotas"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/reporte-cuotas"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/reporte-cuotas"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Reportes de Cuotas" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Gestión de Ventas */}
        <ListItemButton onClick={handleVentasClick}>
          <ListItemText
            primary="Gestión de Ventas"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openVentas ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openVentas} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/solicitudes"
              selected={location.pathname === "/ventas/solicitudes"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/solicitudes"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/solicitudes"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Solicitudes" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/contratos"
              selected={location.pathname === "/ventas/contratos"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/contratos"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/contratos"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Contratos" />
            </ListItemButton>
            {/* 👇 Solo si NO es vendedor mostramos esta ruta */}
            {["administrador", "supervisor"].includes(rol) && (
              <ListItemButton
                component={Link}
                to="/ventas/vendedores"
                selected={location.pathname === "/ventas/vendedores"}
                sx={{
                  pl: 4,
                  bgcolor:
                    location.pathname === "/ventas/vendedores"
                      ? "#0A4575"
                      : "transparent",
                  color:
                    location.pathname === "/ventas/vendedores"
                      ? "#FFFFFF"
                      : "inherit",
                  "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                  "&.Mui-selected": {
                    bgcolor: "#0A4575 !important",
                    color: "#FFFFFF",
                  },
                }}
              >
                <ListItemText primary="Lista de Vendedores" />
              </ListItemButton>
            )}
          </List>
        </Collapse>

        {/* Gestión de Clientes */}
        <ListItemButton onClick={handleClienteClick}>
          <ListItemText
            primary="Gestión de Clientes"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openClientes ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openClientes} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/subir-documento"
              selected={location.pathname === "/ventas/subir-documento"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/subir-documento"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/subir-documento"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Subir Documentos de Identidad" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/subir-documento-familiar"
              selected={
                location.pathname === "/ventas/subir-documento-familiar"
              }
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/subir-documento-familiar"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/subir-documento-familiar"
                    ? "#FFFFFF"
                    : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Subir Documentos de Identidad Familiares" />
            </ListItemButton>
            <ListItemButton
              component={Link}
              to="/ventas/autorizados"
              selected={location.pathname === "/ventas/autorizados"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/autorizados"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/autorizados" ? "#FFFFFF" : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Familiares Autorizados" />
            </ListItemButton>
          </List>
        </Collapse>

        {/* Preguntas Frecuentes */}
        <ListItemButton onClick={handleAyudaClick}>
          <ListItemText
            primary="Ayuda"
            primaryTypographyProps={{
              sx: {
                fontSize: "20px",
                fontFamily: "Bakbak One, sans-serif",
                color: "#0A4575",
              },
            }}
          />
          {openAyuda ? <ExpandLess /> : <ExpandMore />}
        </ListItemButton>
        <Collapse in={openAyuda} timeout="auto" unmountOnExit>
          <List component="div" disablePadding>
            <ListItemButton
              component={Link}
              to="/ventas/ayuda"
              selected={location.pathname === "/ventas/ayuda"}
              sx={{
                pl: 4,
                bgcolor:
                  location.pathname === "/ventas/ayuda"
                    ? "#0A4575"
                    : "transparent",
                color:
                  location.pathname === "/ventas/ayuda" ? "#FFFFFF" : "inherit",
                "&:hover": { bgcolor: "#e2eef7", color: "#000000" },
                "&.Mui-selected": {
                  bgcolor: "#0A4575 !important",
                  color: "#FFFFFF",
                },
              }}
            >
              <ListItemText primary="Preguntas Frecuentes" />
            </ListItemButton>
          </List>
        </Collapse>
      </List>
    </Box>
  );
};

export default VentasLayout;
