// src/utils/CalcularCuota.jsx
export function CalcularMonto({
  precioPlan,
  montoInicial = 0,
  cuotas = 1,
  inicialEnDivisas = false,
}) {
  // Ajusta monto inicial si se paga en divisas (20% de descuento)
  const montoInicialAjustado = inicialEnDivisas
    ? montoInicial * 0.8
    : montoInicial;

  // Calcula saldo a financiar
  const saldo = Math.max(precioPlan - montoInicialAjustado, 0);

  // Calcula monto por cuota (solo si hay más de 1 cuota)
  const montoPorCuota = cuotas > 1 ? saldo / (cuotas - 1) : 0;

  return { saldo, montoPorCuota };
}
