// src/utils/ItemServicios.jsx
import Parcelas from "..//modulo-ventas/Parcelas";
import Cremacion from "..//modulo-ventas/Cremacion";
import Exequia from "..//modulo-ventas/Exequia";
import Inhumacion from "..//modulo-ventas/Inhumacion";
import NichosColumbarios from "..//modulo-ventas/Columbarios";
import NichosAtaud from "..//modulo-ventas/NichosAtaud";
import Funerario from "..//modulo-ventas/Funerarios";

const ItemServicios = ({
  tipoServicio,
  agregarAlPresupuesto,
  resetTrigger,
}) => {
  switch (tipoServicio) {
    case "parcelas":
      return (
        <Parcelas
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "cremacion":
      return (
        <Cremacion
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "honra-exequias":
      return (
        <Exequia
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "inhumacion-parcelas":
      return (
        <Inhumacion
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "nichos-ataud":
      return (
        <NichosAtaud
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "nichos-columbarios":
      return (
        <NichosColumbarios
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    case "plan-funerario":
      return (
        <Funerario
          agregarAlPresupuesto={agregarAlPresupuesto}
          resetTrigger={resetTrigger}
        />
      );
    default:
      return (
        <p style={{ textAlign: "center" }}>Seleccione un servicio válido.</p>
      );
  }
};

export default ItemServicios;
